<?php
echo $this->Form->create('User', array(
    'url'           => array( 'controller' => 'install', 'action' => 'adminuser' ),
    'inputDefaults' => array(
        'label' => false,
        'div'   => false,
        'class' => 'form-control placeholder-no-fix',
        'error' => array(
            'attributes' => array( 'wrap' => 'span', 'class' => 'help-block' )
        )
    ) ));
?>
<div class="install">
    <div class="page-header">
        <h2><?php echo $title_for_layout; ?></h2>
    </div>

    <div class="form-group <?php echo($this->Form->isFieldError('User.email') ? 'has-error' : ''); ?>">
        <label class="control-label" for="UserEmail">Email</label>
        <?php echo $this->Form->input('User.email'); ?>
    </div>

    <div class="form-group <?php echo($this->Form->isFieldError('User.username') ? 'has-error' : ''); ?>">
        <label class="control-label" for="UserUsername">Username</label>
        <?php echo $this->Form->input('User.username'); ?>
    </div>

    <div class="form-group <?php echo($this->Form->isFieldError('User.password') ? 'has-error' : ''); ?>">
        <label class="control-label" for="UserPassword">Password</label>
        <?php echo $this->Form->input('User.password', array( 'type' => 'password' )); ?>
    </div>

    <div class="form-group <?php echo($this->Form->isFieldError('User.confirm_password') ? 'has-error' : ''); ?>">
        <label class="control-label" for="UserConfirmPassword">Confirm Password</label>
        <?php echo $this->Form->input('User.confirm_password', array( 'type' => 'password' )); ?>
    </div>

</div>
<div class="form-actions">
    <?php echo $this->Form->end(array( 'label' => 'Save', 'class' => 'btn btn-success' )); ?>
</div>
